<?php

namespace App\Modules\CustomerService\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'messages';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('customer_name', 'phone', 'identification_number', 'customer_service_id', 'type', 'content');

    public function customer_service()
    {
        return $this->belongsTo('App\Modules\CustomerService\Entities\CustomerService', 'customer_service_id');
    }

}